<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
	if ((class_exists('WPBakeryShortCode')) && (!class_exists('WPBakeryShortCode_TS_VCSC_Icon_Info_Box'))) {
		class WPBakeryShortCode_TS_VCSC_Icon_Info_Box extends WPBakeryShortCode {};
	};
    $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element = array(
		"name"                      	=> __( "TS Icon Info Box", "ts_visual_composer_extend" ),
		"base"                      	=> "TS_VCSC_Icon_Info_Box",
		"icon" 	                    	=> "ts-composer-element-icon-info-textbox",
		"category"                  	=> __( "Composium", "ts_visual_composer_extend" ),
		"description"               	=> __("Place an icon info box element", "ts_visual_composer_extend"),
		"admin_enqueue_js"        		=> "",
		"admin_enqueue_css"       		=> "",
		"params"                    	=> array(
			// Main Icon Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_1",
				"seperator"         	=> "Main Icon",
				"group" 				=> "Icon",
			),
			array(
				"type"					=> "dropdown",
				"heading"				=> __( "Main Icon: Source", "ts_visual_composer_extend" ),
				"param_name"			=> "icon_decoration",
				"width"					=> 150,
				"value"					=> array(
					__( 'Use Font Icon', "ts_visual_composer_extend" )  		=> "icon",
					__( 'Use Image Icon', "ts_visual_composer_extend" )  		=> "image",
					__( 'No Icon', "ts_visual_composer_extend" )				=> "none",
				),
				"admin_label"       	=> true,
				"description"			=> __( "Select if and what type of background icon should be used for the info box.", "ts_visual_composer_extend" ),
				"group" 				=> "Icon",
			),
			array(
				"type"					=> "dropdown",
				"heading"				=> __( "Main Icon: Position", "ts_visual_composer_extend" ),
				"param_name"			=> "icon_position",
				"width"					=> 150,
				"value"					=> array(
					__( 'Left', "ts_visual_composer_extend" )   				=> "left",
					__( 'Right', "ts_visual_composer_extend" )  				=> "right",
					__( 'Top', "ts_visual_composer_extend" )					=> "top",
					__( 'Bottom', "ts_visual_composer_extend" )					=> "bottom",
				),
				"admin_label"       	=> true,
				"description"			=> __( "Define where the main icon should be shown in relation to the main content.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "icon_decoration", 'value' => array('icon', 'image') ),
				"group" 				=> "Icon",
			),
			array(
				"type" 					=> "icons_panel",
				'heading' 				=> __( 'Main Icon: Type', 'ts_visual_composer_extend' ),
				'param_name' 			=> 'icon_main',
				'value'					=> '',
				"settings" 				=> array(
					"emptyIcon" 				=> false,
					'emptyIconValue'			=> 'transparent',
					"type" 						=> 'extensions',
				),
				"description"       	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the main icon for the info box.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
				"dependency"			=> array( 'element' => "icon_decoration", 'value' => 'icon' ),
				"group" 				=> "Icon",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Main Icon: Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "icon_color",
				"value"             	=> "#ffffff",
				"description"       	=> __( "Define the color for the main icon.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "icon_decoration", 'value' => 'icon' ),
				"group" 				=> "Icon",
			),
			array(
				"type"                  => "attach_image",
				"heading"               => __( "Main Icon: Image", "ts_visual_composer_extend" ),
				"param_name"            => "icon_image",
				"value"                 => "",
				"description"       => __( "Image must have equal dimensions for scaling purposes (i.e. 100x100).", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "icon_decoration", 'value' => 'image' ),
				"group" 				=> "Icon",
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Main Icon: Animation", "ts_visual_composer_extend" ),
				"param_name"        	=> "icon_animationtype",
				"width"             	=> 150,
				"value"             	=> array(
					__( "No Animation", "ts_visual_composer_extend" )    							=> "none",
					__( "One Time Effect while Hover", "ts_visual_composer_extend" )    			=> "ts-hover-css-",
					__( "Infinite (Looping) Effect", "ts_visual_composer_extend" )                	=> "ts-infinite-css-",
				),
				"description"       	=> __( "Select the animation type for the main icon.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "icon_decoration", 'value' => array('icon', 'image') ),
				"group" 				=> "Icon",
			),
			array(
				"type"					=> "css3animations",
				"heading"				=> __("Main Icon: Animation", "ts_visual_composer_extend"),
				"param_name"			=> "icon_animationclass",
				"prefix"				=> "",
				"connector"				=> "icon_animationname",
				"noneselect"			=> "false",
				"default"				=> "",
				"value"					=> "",
				"admin_label"			=> false,
				"description"			=> __("Select the animation effect for the main icon.", "ts_visual_composer_extend"),
				"dependency"        	=> array( 'element' => "icon_animationtype", 'value' => array('ts-hover-css-', 'ts-infinite-css-') ),
				"group" 				=> "Icon",
			),
			array(
				"type"					=> "hidden_input",
				"heading"				=> __( "Main Icon: Animation", "ts_visual_composer_extend" ),
				"param_name"			=> "icon_animationname",
				"value"					=> "",
				"dependency"        	=> array( 'element' => "icon_animationtype", 'value' => array('ts-hover-css-', 'ts-infinite-css-') ),
				"group" 				=> "Icon",
			),			
			// Background Icon
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_2",
				"seperator"         	=> "Background Icon",
				"group" 				=> "Icon",
			),
			array(
				"type"					=> "dropdown",
				"heading"				=> __( "Background Icon: Position", "ts_visual_composer_extend" ),
				"param_name"			=> "icon_backposition",
				"width"					=> 150,
				"value"					=> array(
					__( 'Left', "ts_visual_composer_extend" )   				=> "left",
					__( 'Right', "ts_visual_composer_extend" )  				=> "right",
				),
				"dependency"			=> array( 'element' => "icon_position", 'value' => array('top', 'bottom') ),
				"description"			=> __( "Define where the optional background icon should be shown in relation to the main content.", "ts_visual_composer_extend" ),
				"group" 				=> "Icon",
			),
			array(
				"type"					=> "dropdown",
				"heading"				=> __( "Background Icon: Source", "ts_visual_composer_extend" ),
				"param_name"			=> "icon_usage",
				"width"					=> 150,
				"value"					=> array(
					__( 'Same As Main Icon', "ts_visual_composer_extend" )   	=> "main",
					__( 'Use Other Font Icon', "ts_visual_composer_extend" )  	=> "other",
					__( 'Use Image Icon', "ts_visual_composer_extend" )  		=> "image",
					__( 'No Background Icon', "ts_visual_composer_extend" )		=> "none",
				),
				"description"			=> __( "Select if and what type of background icon should be used for the info box.", "ts_visual_composer_extend" ),
				"group" 				=> "Icon",
			),
			array(
				"type" 					=> "icons_panel",
				'heading'				=> __( 'Background Icon: Type', 'ts_visual_composer_extend' ),
				'param_name'			=> 'icon_backclass',
				'value'					=> '',
				"settings" 				=> array(
					"emptyIcon" 				=> false,
					'emptyIconValue'			=> 'transparent',
					"type" 						=> 'extensions',
				),
				"dependency"			=> array( 'element' => "icon_usage", 'value' => 'other' ),
				"description"			=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the background icon for the info box.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
				"group" 				=> "Icon",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Background Icon: Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "icon_backcolor",
				"value"             	=> "rgba(255, 255, 255, 0.5)",
				"dependency"			=> array( 'element' => "icon_usage", 'value' => array('main', 'other') ),
				"group" 				=> "Icon",
			),
			array(
				"type"                  => "attach_image",
				"heading"               => __( "Background Icon: Image", "ts_visual_composer_extend" ),
				"param_name"            => "icon_backimage",
				"value"                 => "",
				"description"       => __( "Image must have equal dimensions for scaling purposes (i.e. 100x100).", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "icon_usage", 'value' => 'image' ),
				"group" 				=> "Icon",
			),			
			// Title Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_3",
				"seperator"				=> "Title Settings",
				"group"					=> "Title"
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Title", "ts_visual_composer_extend" ),
				"param_name"        	=> "title_string",
				"value"             	=> "",
				"admin_label"       	=> true,
				"group"					=> "Title"
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Title: Font Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "title_color",
				"value"             	=> "#ffffff",
				"group"					=> "Title"
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Title: Font Size", "ts_visual_composer_extend" ),
				"param_name"        	=> "title_size",
				"value"             	=> "24",
				"min"               	=> "14",
				"max"               	=> "72",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"group"					=> "Title"
			),
			array(
				"type"					=> "fontsmanager",
				"heading"				=> __( "Title: Font Family", "ts_visual_composer_extend" ),
				"param_name"			=> "title_family",
				"value"					=> "",
				"default"				=> "true",
				"connector"				=> "title_type",
				"group"					=> "Title"
			),
			array(
				"type"					=> "hidden_input",
				"param_name"			=> "title_type",
				"value"					=> "",
				"group"					=> "Title"
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Title: Horizontal Align", "ts_visual_composer_extend" ),
				"param_name"        	=> "title_align",
				"width"             	=> 150,
				"value"             	=> array(
					__( 'Center', "ts_visual_composer_extend" )   	=> "center",
					__( 'Left', "ts_visual_composer_extend" )  		=> "left",
					__( 'Right', "ts_visual_composer_extend" )     	=> "right",
					__( 'Justify', "ts_visual_composer_extend" )   	=> "justify",
				),
				"default"				=> "left",
				"standard"				=> "left",
				"std"					=> "left",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group"					=> "Title"
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Title: Font Weight", "ts_visual_composer_extend" ),
				"param_name"        	=> "title_weight",
				"width"             	=> 150,
				"value"             	=> array(
					__( 'Default', "ts_visual_composer_extend" )  => "inherit",
					__( 'Bold', "ts_visual_composer_extend" )     => "bold",
					__( 'Bolder', "ts_visual_composer_extend" )   => "bolder",
					__( 'Normal', "ts_visual_composer_extend" )   => "normal",
					__( 'Light', "ts_visual_composer_extend" )    => "300",
				),
				"default"				=> "300",
				"standard"				=> "300",
				"std"					=> "300",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group"					=> "Title"
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Title: Transform Effect", "ts_visual_composer_extend" ),
				"param_name"        	=> "title_transform",
				"width"             	=> 300,
				"value"             	=> array(
					__( 'None', "ts_visual_composer_extend" )			=> "none",
					__( 'Capitalize', "ts_visual_composer_extend" )		=> "capitalize",			 
					__( 'Uppercase', "ts_visual_composer_extend" )		=> "uppercase",
					__( 'Lowercase', "ts_visual_composer_extend" )		=> "lowercase",
				),
				"default"				=> "uppercase",
				"standard"				=> "uppercase",
				"std"					=> "uppercase",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group"					=> "Title"
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Title: Decoration", "ts_visual_composer_extend" ),
				"param_name"        	=> "title_decoration",
				"width"             	=> 300,
				"value"             	=> array(
					__( 'None', "ts_visual_composer_extend" )       	=> "none",
					__( 'Underline', "ts_visual_composer_extend" )		=> "underline",			 
					__( 'Overline', "ts_visual_composer_extend" )		=> "overline",
					__( 'Line Through', "ts_visual_composer_extend" )	=> "line-through",
				),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group"					=> "Title"
			),	
			// Content Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_4",
				"seperator"				=> "Content Settings",
				"group"					=> "Content"
			),
			array(
				"type"					=> "textarea_html",
				"heading"				=> __( "Content", "ts_visual_composer_extend" ),
				"param_name"			=> "content",
				"value"					=> "I am an icon info box. Click the edit button to change this text.",
				"group"					=> "Content"
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Content: Font Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_color",
				"value"             	=> "#f2f2f2",
				"group"					=> "Content"
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Content: Font Size", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_size",
				"value"             	=> "14",
				"min"               	=> "10",
				"max"               	=> "48",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"group"					=> "Content"
			),
			array(
				"type"					=> "fontsmanager",
				"heading"				=> __( "Content: Font Family", "ts_visual_composer_extend" ),
				"param_name"			=> "content_family",
				"value"					=> "",
				"default"				=> "true",
				"connector"				=> "content_type",
				"group"					=> "Content"
			),
			array(
				"type"					=> "hidden_input",
				"param_name"			=> "content_type",
				"value"					=> "",
				"group"					=> "Content"
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Content: Horizontal Align", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_align",
				"width"             	=> 150,
				"value"             	=> array(
					__( 'Center', "ts_visual_composer_extend" )   	=> "center",
					__( 'Left', "ts_visual_composer_extend" )  		=> "left",
					__( 'Right', "ts_visual_composer_extend" )     	=> "right",
					__( 'Justify', "ts_visual_composer_extend" )   	=> "justify",
				),
				"default"				=> "justify",
				"standard"				=> "justify",
				"std"					=> "justify",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group"					=> "Content"
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Content: Font Weight", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_weight",
				"width"             	=> 150,
				"value"             	=> array(
					__( 'Default', "ts_visual_composer_extend" )  => "inherit",
					__( 'Bold', "ts_visual_composer_extend" )     => "bold",
					__( 'Bolder', "ts_visual_composer_extend" )   => "bolder",
					__( 'Normal', "ts_visual_composer_extend" )   => "normal",
					__( 'Light', "ts_visual_composer_extend" )    => "300",
				),				
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group"					=> "Content"
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Content: Transform Effect", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_transform",
				"width"             	=> 300,
				"value"             	=> array(
					__( 'None', "ts_visual_composer_extend" )			=> "none",
					__( 'Capitalize', "ts_visual_composer_extend" )		=> "capitalize",			 
					__( 'Uppercase', "ts_visual_composer_extend" )		=> "uppercase",
					__( 'Lowercase', "ts_visual_composer_extend" )		=> "lowercase",
				),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group"					=> "Content"
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Content: Decoration", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_decoration",
				"width"             	=> 300,
				"value"             	=> array(
					__( 'None', "ts_visual_composer_extend" )       	=> "none",
					__( 'Underline', "ts_visual_composer_extend" )		=> "underline",			 
					__( 'Overline', "ts_visual_composer_extend" )		=> "overline",
					__( 'Line Through', "ts_visual_composer_extend" )	=> "line-through",
				),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group"					=> "Content"
			),	
			// Background Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_5",
				"seperator"				=> "Box Background",
				"group" 				=> "Box Styling",
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Box: Background Type", "ts_visual_composer_extend" ),
				"param_name"        	=> "style_backtype",
				"width"             	=> 300,
				"value"             	=> array(
					__( "Solid Color", "ts_visual_composer_extend" )				=> "color",
					__( "Gradient Background", "ts_visual_composer_extend" )		=> "gradient",
					__( "Background Pattern", "ts_visual_composer_extend" )			=> "pattern",
					__( "Custom Image", "ts_visual_composer_extend" )				=> "image",
					__( "Transparent Background", "ts_visual_composer_extend" )		=> "transparent",
				),
				"group"					=> "Box Styling"
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Box: Background Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "style_backcolor",
				"value"             	=> "#2c3e50",
				"dependency"        	=> array( 'element' => "style_backtype", 'value' => 'color' ),
				"group"					=> "Box Styling"
			),
			array(
				"type"					=> "advanced_gradient",
				"heading"				=> __("Box: Gradient Background", "ts_visual_composer_extend"),						
				"param_name"			=> "style_backgradient",
				"description"			=> __('Use the controls above to create a custom gradient background for the element.', 'ts_visual_composer_extend'),
				"dependency"       	 	=> array( 'element' => "style_backtype", 'value' => 'gradient' ),
				"group"					=> "Box Styling"
			),		
			array(
				"type"              	=> "background",
				"heading"           	=> __( "Box: Background Pattern", "ts_visual_composer_extend" ),
				"param_name"        	=> "style_backpattern",
				"height"            	=> 200,
				"pattern"           	=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Background_List,
				"value"					=> "",
				"encoding"          	=> "false",
				"empty"					=> "true",
				"description"       	=> __( "Select the background pattern for your icon box.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "style_backtype", 'value' => 'pattern' ),
				"group"					=> "Box Styling"
			),
			array(
				"type"              	=> "attach_image",
				"heading"           	=> __( "Box: Background Image", "ts_visual_composer_extend" ),
				"param_name"        	=> "style_backimage",
				"value"             	=> "",
				"description"       	=> __( "Select an image or pattern to be used as background for the icon box.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "style_backtype", 'value' => 'image' ),
				"group"					=> "Box Styling"
			),
			array(
				"type"					=> "dropdown",
				"heading"				=> __( "Background Size", "ts_visual_composer_extend" ),
				"param_name"			=> "style_backsize",
				"width"					=> 150,
				"value"					=> array(
					__( "Cover", "ts_visual_composer_extend" ) 			=> "cover",
					__( "100%", "ts_visual_composer_extend" )			=> "100%",
					__( "150%", "ts_visual_composer_extend" )			=> "150%",
					__( "200%", "ts_visual_composer_extend" )			=> "200%",
					__( "Contain", "ts_visual_composer_extend" ) 		=> "contain",
					__( "Initial", "ts_visual_composer_extend" ) 		=> "initial",
					__( "Auto", "ts_visual_composer_extend" ) 			=> "auto",
				),
				"description"			=> __( "Select how the custom background image should be sized.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "style_backtype", 'value' => 'image' ),
				"group"					=> "Box Styling"
			),
			array(
				"type"					=> "dropdown",
				"heading"				=> __( "Background Repeat", "ts_visual_composer_extend" ),
				"param_name"			=> "style_backrepeat",
				"width"					=> 150,
				"value"					=> array(
					__( "No Repeat", "ts_visual_composer_extend" )		=> "no-repeat",
					__( "Repeat X + Y", "ts_visual_composer_extend" )	=> "repeat",
					__( "Repeat X", "ts_visual_composer_extend" )		=> "repeat-x",
					__( "Repeat Y", "ts_visual_composer_extend" )		=> "repeat-y"
				),
				"description"			=> __( "Select if and how the background image should be repeated.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "style_backtype", 'value' => 'image' ),
				"group"					=> "Box Styling"
			),
			array(
				"type" 					=> "dropdown",
				"heading" 				=> __( "Background Position", "ts_visual_composer_extend" ),
				"param_name" 			=> "style_backposition",
				"value" 				=> array(
					__( "Center Center", "ts_visual_composer_extend" ) 				=> "center",
					__( "Center Top", "ts_visual_composer_extend" )					=> "top",
					__( "Center Bottom", "ts_visual_composer_extend" ) 				=> "bottom",
					__( "Left Top", "ts_visual_composer_extend" ) 					=> "left top",
					__( "Left Center", "ts_visual_composer_extend" ) 				=> "left center",
					__( "Left Bottom", "ts_visual_composer_extend" ) 				=> "left bottom",
					__( "Right Top", "ts_visual_composer_extend" ) 					=> "right top",
					__( "Right Center", "ts_visual_composer_extend" ) 				=> "right center",
					__( "Right Bottom", "ts_visual_composer_extend" ) 				=> "right bottom",
				),
				"dependency"        	=> array( 'element' => "style_backtype", 'value' => 'image' ),
				"group"					=> "Box Styling"
			),
			// Border Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_6",
				"seperator"				=> "Border Settings",
				"group" 				=> "Box Styling",
			),
			array(
				"type" 					=> "advanced_styling",
				"heading" 				=> __("Box: Border Settings", "ts_visual_composer_extend"),
				"param_name" 			=> "style_boxborder",
				"style_type"			=> "border",
				"show_main"				=> "false",
				"show_preview"			=> "true",
				"show_width"			=> "true",
				"show_style"			=> "true",
				"show_radius" 			=> "true",					
				"show_color"			=> "true",
				"show_unit_width"		=> "true",
				"show_unit_radius"		=> "true",
				"override_all"			=> "true",
				"default_positions"		=> array(
					"All" 						=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "1", "unitwidth" => "px", "style" => "solid", "color" => "#15273a", "radius" => "0", "unitradius" => "px"),
					"Top" 						=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "1", "unitwidth" => "px", "style" => "solid", "color" => "#15273a", "radius" => "0", "unitradius" => "px"),
					"Right" 					=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "1", "unitwidth" => "px", "style" => "solid", "color" => "#15273a", "radius" => "0", "unitradius" => "px"),
					"Bottom" 					=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "1", "unitwidth" => "px", "style" => "solid", "color" => "#15273a", "radius" => "0", "unitradius" => "px"),
					"Left" 						=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "1", "unitwidth" => "px", "style" => "solid", "color" => "#15273a", "radius" => "0", "unitradius" => "px"),
				),
				"description"       	=> __( "Define the border settings for each side and corner of the element.", "ts_visual_composer_extend" ),
				"group"					=> "Box Styling"
			),
			array(
				"type"              	=> "switch_button",
				"heading"           	=> __( "Box: Border Corner Effect", "ts_visual_composer_extend" ),
				"param_name"        	=> "style_bordereffect",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to use an animated corner border effect with the element.", "ts_visual_composer_extend" ),
				"group"					=> "Box Styling"
			),			
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Corner Border: Strength", "ts_visual_composer_extend" ),
				"param_name"        	=> "style_borderwidth",
				"value"             	=> "2",
				"min"               	=> "1",
				"max"               	=> "10",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the desired strength for the corner borders.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "style_bordereffect", 'value' => 'true' ),
				"group"					=> "Box Styling"
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Corner Border: Spacing", "ts_visual_composer_extend" ),
				"param_name"        	=> "style_borderspace",
				"value"             	=> "2",
				"min"               	=> "1",
				"max"               	=> "10",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the desired spacing between the corner borders and the main info box element.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "style_bordereffect", 'value' => 'true' ),
				"group"					=> "Box Styling"
			),			
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Corner Border: Color Top Left", "ts_visual_composer_extend" ),
				"param_name"        	=> "style_bordercolor1",
				"value"             	=> "#15273a",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "style_bordereffect", 'value' => 'true' ),
				"group"					=> "Box Styling"
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Corner Border: Color Bottom Right", "ts_visual_composer_extend" ),
				"param_name"        	=> "style_bordercolor2",
				"value"             	=> "#15273a",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "style_bordereffect", 'value' => 'true' ),
				"group"					=> "Box Styling"
			),
			// Link Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_7",
				"seperator"				=> "Link Settings",
				"group" 				=> "Link Settings",
			),
			array(
				"type" 					=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ParameterLinkPicker['enabled'] == "false" ? "vc_link" : "advancedlinks"),
				"heading" 				=> __("Link: Information", "ts_visual_composer_extend"),
				"param_name" 			=> "link_data",
				"description" 			=> __("Provide a link to another site/page for the Icon Button.", "ts_visual_composer_extend"),
				"group" 				=> "Link Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Link: Effect", "ts_visual_composer_extend" ),
				"param_name"            => "link_effect",
				"width"                 => 300,
				"value"                 => array(
					__( 'Effect', "ts_visual_composer_extend" ) . ' 1'		=> "effect-1",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 2'		=> "effect-2",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 3'		=> "effect-3",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 4'		=> "effect-4",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 5'		=> "effect-5",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 6'		=> "effect-6",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 7'		=> "effect-7",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 8'		=> "effect-8",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 9'		=> "effect-9",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 10'		=> "effect-10",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 11'		=> "effect-11",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 12'		=> "effect-12",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 13'		=> "effect-13",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 14'		=> "effect-14",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 15'		=> "effect-15",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 16'		=> "effect-16",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 17'		=> "effect-17",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 18'		=> "effect-18",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 19'		=> "effect-19",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 20'		=> "effect-20",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 21'		=> "effect-21",
				),
				"description"           => __( "Select the effect style for the link", "ts_visual_composer_extend" ),
				"group" 				=> "Link Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Link: Text", "ts_visual_composer_extend" ),
				"param_name"            => "link_content",
				"value"                 => "Link Text",
				"description"           => __( "Enter the text string that should be used for the link; HTML code or shortcode can NOT be used.", "ts_visual_composer_extend" ),
				"group" 				=> "Link Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Link: Message", "ts_visual_composer_extend" ),
				"param_name"            => "link_message",
				"value"                 => "Link Message",
				"description"           => __( "Enter an optional VERY short message for the link; HTML code can NOT be used.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "link_effect", 'value' => array('effect-9') ),
				"group" 				=> "Link Settings",
			),		
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Link: Text Align", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_align",
				"width"             	=> 300,
				"value"             	=> array(
					__( 'Center', "ts_visual_composer_extend" )      	=> "center",
					__( 'Left', "ts_visual_composer_extend" )			=> "left",
					__( 'Right', "ts_visual_composer_extend" )  		=> "right",
				),
				"default"				=> "left",
				"standard"				=> "left",
				"std"					=> "left",
				"description"       	=> __( "Select how the text for the link should be aligned.", "ts_visual_composer_extend" ),
				"group" 				=> "Link Settings",
			),			
			array(
				"type"              	=> "switch_button",
				"heading"           	=> __( "Link: Uppercase", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_uppercase",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to transform all link text characters to uppercase.", "ts_visual_composer_extend" ),
				"group" 				=> "Link Settings",
			),			
			array(
				"type"              	=> "fontsmanager",
				"heading"           	=> __( "Link: Font Family", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_font_family",
				"value"             	=> "",
				"default"				=> "true",
				"connector"				=> "link_font_type",
				"description"       	=> __( "Select the font to be used for the title text.", "ts_visual_composer_extend" ),
				"group" 				=> "Link Settings",
			),
			array(
				"type"              	=> "hidden_input",
				"param_name"        	=> "link_font_type",
				"value"             	=> "",
				"group" 				=> "Link Settings",
			),				
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Link: Text Standard Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_text_color",
				"value"             	=> "#d6d6d6",
				"description"       	=> __( "Define the standard color of the text for the link.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group" 				=> "Link Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Link: Text Hover Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_text_hover",
				"value"             	=> "#ffffff",
				"description"       	=> __( "Define the hover color of the text for the link.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group" 				=> "Link Settings",
			),				
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Link: Message Standard Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_message_color",
				"value"             	=> "#cccccc",
				"description"       	=> __( "Define the standard color of the message for the link.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"			=> array( 'element' => "link_effect", 'value' => array('effect-9') ),
				"group" 				=> "Link Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Link: Message Hover Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_message_hover",
				"value"             	=> "#cccccc",
				"description"       	=> __( "Define the hover color of the message for the link.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"			=> array( 'element' => "link_effect", 'value' => array() ),
				"group" 				=> "Link Settings",
			),				
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Link: Background Standard Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_back_color",
				"value"             	=> "#001f3a",
				"description"       	=> __( "Define the standard background color of the link.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "link_effect", 'value' => array('effect-2', 'effect-10', 'effect-19', 'effect-20') ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group" 				=> "Link Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Link: Background Hover Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_back_hover",
				"value"             	=> "#011425",
				"description"       	=> __( "Define the hover background color of the link.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "link_effect", 'value' => array('effect-2', 'effect-10', 'effect-19', 'effect-20') ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group" 				=> "Link Settings",
			),				
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Link: Border Type", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_border_type",
				"width"             	=> 300,
				"value"             	=> array(						
					__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
					__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
					__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
					__( "Double Border", "ts_visual_composer_extend" )                 => "double",
					__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
					__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
					__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
					__( "Outset Border", "ts_visual_composer_extend" )                 => "outset",
				),
				"description"       	=> __( "Select the type of border for the creative link.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "link_effect", 'value' => array('effect-3', 'effect-4', 'effect-8', 'effect-11') ),
				"group" 				=> "Link Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Link: Border Width", "ts_visual_composer_extend" ),
				"param_name"            => "link_border_width",
				"value"                 => "2",
				"min"                   => "1",
				"max"                   => "20",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"       	=> __( "Define the border width for the creative link.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "link_effect", 'value' => array('effect-3', 'effect-4', 'effect-6', 'effect-7', 'effect-8', 'effect-11') ),
				"group" 				=> "Link Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Link: Border Standard Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_border_color",
				"value"             	=> "#cccccc",
				"description"       	=> __( "Define the border standard color for the creative link.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "link_effect", 'value' => array('effect-3', 'effect-4', 'effect-6', 'effect-7', 'effect-8', 'effect-9', 'effect-12', 'effect-13', 'effect-14', 'effect-18', 'effect-20', 'effect-21') ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group" 				=> "Link Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Link: Border Hover Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_border_hover",
				"value"             	=> "#ededed",
				"description"       	=> __( "Define the border hover color for the creative link.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "link_effect", 'value' => array('effect-8') ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group" 				=> "Link Settings",
			),
			// Viewport Animation
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_8",
				"seperator"				=> "Viewport Animation",
				"group" 				=> "Other Settings",
			),			
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Viewport Animation", "ts_visual_composer_extend" ),
				"param_name"        	=> "viewport_usage",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to apply a viewport animation to the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"					=> "css3animations",
				"heading"				=> __("Viewport Animation", "ts_visual_composer_extend"),
				"param_name"			=> "viewport_class",
				"prefix"				=> "ts-viewport-css-",
				"connector"				=> "viewport_name",
				"noneselect"			=> "false",
				"default"				=> "",
				"value"					=> "",
				"admin_label"			=> false,
				"description"			=> __("Select the viewport animation for the element.", "ts_visual_composer_extend"),
				"dependency"        	=> array( 'element' => "viewport_usage", 'value' => 'true' ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"					=> "hidden_input",
				"heading"				=> __( "Viewport Animation", "ts_visual_composer_extend" ),
				"param_name"			=> "viewport_name",
				"value"					=> "",
				"admin_label"			=> true,
				"dependency"        	=> array( 'element' => "viewport_usage", 'value' => 'true' ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"					=> "nouislider",
				"heading"				=> __( "Viewport Delay", "ts_visual_composer_extend" ),
				"param_name"			=> "viewport_delay",
				"value"					=> "0",
				"min"					=> "0",
				"max"					=> "20000",
				"step"					=> "100",
				"unit"					=> 'ms',
				"description"			=> __( "Define how long the CSS3 animation should be delayed after it has been triggered.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "viewport_usage", 'value' => 'true' ),
				"group" 				=> "Other Settings",
			),
			array(
				"type" 					=> "viewport_offset",
				"heading" 				=> __( "Viewport Offset", "ts_visual_composer_extend"),
				"param_name" 			=> "viewport_offset",
				"value" 				=> '50%',
				"description" 			=> __("Define the offset (top of screen) that should trigger the viewport animation.", "ts_visual_composer_extend"),
				"dependency" 			=> array( 'element' => "viewport_usage", 'value' => 'true' ),
				"group" 				=> "Other Settings",
			),			
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Viewport Minimum", "ts_visual_composer_extend" ),
				"param_name"        	=> "viewport_limit",
				"value"             	=> "360",
				"min"               	=> "0",
				"max"               	=> "1024",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define a minimum screen width that is required to show the viewport animation.", "ts_visual_composer_extend" ),
				"dependency" 			=> array( 'element' => "viewport_usage", 'value' => 'true' ),
				"group" 				=> "Other Settings",
			),
			// Other Conditionals
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_9",
				"seperator"				=> "Output Conditions",
				"group" 				=> "Other Settings",
			),
			array(
				"type"              	=> "ts_conditionals",
				"heading"				=> __( "Output Conditions", "ts_visual_composer_extend" ),
				"param_name"        	=> "conditionals",
				"group" 				=> "Other Settings",
			),
			// Other Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_10",
				"seperator"				=> "Other Settings",
				"group" 				=> "Other Settings",
			),	
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Margin: Top", "ts_visual_composer_extend" ),
				"param_name"        	=> "margin_top",
				"value"             	=> "0",
				"min"               	=> "-50",
				"max"               	=> "200",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Margin: Bottom", "ts_visual_composer_extend" ),
				"param_name"        	=> "margin_bottom",
				"value"             	=> "0",
				"min"               	=> "-50",
				"max"               	=> "200",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Define ID Name", "ts_visual_composer_extend" ),
				"param_name"        	=> "el_id",
				"value"             	=> "",
				"description"       	=> __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "tag_editor",
				"heading"           	=> __( "Extra Class Names", "ts_visual_composer_extend" ),
				"param_name"            => "el_class",
				"value"                 => "",
				"description"      		=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
		)
	);	
	if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
		return $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element;
	} else {			
		vc_map($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element);
	};
?>